#include <bits/stdc++.h>
using namespace std;

struct Point {
    double x, y;
};

double dist(const Point &a, const Point &b) {
    return fabs(a.x - b.x) + fabs(a.y - b.y);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    double eps;
    cin >> n >> eps;

    vector<Point> p(n);
    for (int i = 0; i < n; i++) {
        cin >> p[i].x >> p[i].y;
    }

    long long limit = (long long)floor(18.0 / (eps * eps));

    if (limit < n) {
        n = limit;
        p.resize(n);
    }

    vector<double> minDist(n, 1e18);
    vector<int> parent(n, -1);
    vector<bool> used(n, false);

    minDist[0] = 0;

    for (int i = 0; i < n; i++) {
        int v = -1;
        for (int j = 0; j < n; j++) {
            if (!used[j] && (v == -1 || minDist[j] < minDist[v])) {
                v = j;
            }
        }

        used[v] = true;

        for (int u = 0; u < n; u++) {
            if (!used[u]) {
                double d = dist(p[v], p[u]);
                if (d < minDist[u]) {
                    minDist[u] = d;
                    parent[u] = v;
                }
            }
        }
    }

    cout << n << "\n";
    for (int i = 0; i < n; i++) {
        cout << i + 1 << (i + 1 == n ? '\n' : ' ');
    }

    for (int i = 1; i < n; i++) {
        cout << parent[i] + 1 << " " << i + 1 << "\n";
    }

    return 0;
}